<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;
/**
 * 显示评论人使用的操作系统和浏览器信息（Handsome主题专用）</br> 更新时间: <code style="padding: 2px 4px; font-size: 90%; color: #c7254e; background-color: #f9f2f4; border-radius: 4px;">2025-07-23</code>
 * @package UserAgent
 * @author  松鼠大大
 * @version 1.2.0
 * @link https://doge.uk/
 */
class UserAgent_Plugin implements Typecho_Plugin_Interface
{
	/**
	 * 激活插件方法,如果激活失败,直接抛出异常
	 *
	 * @access public
	 * @return void
	 * @throws Typecho_Plugin_Exception
	 */
	public static function activate()
	{
		Typecho_Plugin::factory('Widget_Archive')->header = array(__CLASS__, 'header');
		Typecho_Plugin::factory('Widget_Archive')->footer = array(__CLASS__, 'footer');
		Typecho_Plugin::factory('Widget_Archive')->handleInit = array(__CLASS__, 'handleInit');
		return _t('插件安装成功,请在需要显示评论信息的位置插入嵌入点代码!!!');
	}
	
	/**
	 * 禁用插件方法,如果禁用失败,直接抛出异常
	 *
	 * @static
	 * @access public
	 * @return void
	 * @throws Typecho_Plugin_Exception
	 */
	public static function deactivate()
	{
		return _t('插件卸载成功');
	}

	/**
	 * 获取插件配置面板
	 *
	 * @access public
	 * @param Typecho_Widget_Helper_Form $form 配置面板
	 * @return void
	 */
	public static function config(Typecho_Widget_Helper_Form $form)
	{	
		$element = new Typecho_Widget_Helper_Form_Element_Radio('info', array(0 => _t('只显示 ICON'), 1 => _t('显示 ICON + UA 详细 ')), 1, _t('请选择 UA 信息展示方式'));
		$form->addInput($element);
	
		$element = new Typecho_Widget_Helper_Form_Element_Checkbox('effect', array('color' => _t('鼠标经过或悬停时显示UA信息'), 'visible' => _t('仅博主可见')), array('visible'), _t('请选择 UA 信息展示效果'));
		$form->addInput($element);
	
		$element = new Typecho_Widget_Helper_Form_Element_Checkbox('color', array('color' => _t('显示随机颜色')), array('color'), _t('是否显示随机颜色'), _t('默认勾选,显示随机颜色,此时自定义RGB颜色值不可用.'));
		$form->addInput($element);
		
		$element = new Typecho_Widget_Helper_Form_Element_Text('color_value', null, '#924cda', _t('自定义RGB颜色值'), _t('填入自己喜欢的RGB颜色值代码,例如: #924cda </br><b>注意: </b>随机颜色未选中时方可使用！！！'));
		$form->addInput($element);
	
		$element = new Typecho_Widget_Helper_Form_Element_Checkbox('ip', array('loc' => _t('显示IP位置信息'), 'visible' => _t('仅博主可见')), array('loc', 'visible'), _t('是否显示IP位置信息'), _t('默认勾选,显示IP位置信息,查询比较耗时,轻微影响用户浏览体验.'));
		$form->addInput($element);
		
		$element = new Typecho_Widget_Helper_Form_Element_Select('ipv4_source',
			array(
				'qqwry'=>_t('纯真数据库'),
				'IPIP'=>_t('IPIPFree.net')
			),
			'qqwry',
			_t('请选择内置IP数据库 [IPV4]'),
			_t('插件内置<a href="https://github.com/metowolf/qqwry.ipdb" target="_blank">纯真数据库</a>和IPIPFree数据库,IPIPFree仅支持IPV4地址查询。')
		);
		$form->addInput($element);

		$element = new Typecho_Widget_Helper_Form_Element_Select('ipv6_source',
			array(
				'ipv6wry'=>_t('IPV6WRY'),
			),
			'ipv6wry',
			_t('请选择内置IP数据库 [IPV6]'),
			_t('插件内置<a href="https://github.com/yindashan/ipv6wry.db" target="_blank">ipv6wry.db</a>数据库,支持IPV6地址查询。')
		);
		$form->addInput($element);		
		
		$element = new Typecho_Widget_Helper_Form_Element_Select('api',
			array(
				'SB'=>_t('IP.SB (国外首选)'),
				'VORE-API'=>_t('vore.top (稳定性未知)'),
				'Mir6'=>_t('mir6.com (大陆优先/稳定性未知)'),
				'IP-API'=>_t('IP-API.com (45 req/min)'),
				'IPinfo'=>_t('IPinfo.io (50k req/mo)'),
				'None'=>_t('禁用此功能')
			),
			'None',
			_t('请选择第三方获取IP信息的API接口 [支持IPV4&IPV6]'),
			_t('此项用于本地IP数据库查询失败后,从第三方接口查询IP信息</br>国外主机推荐选择 <a href="https://ip.sb" target="_blank">IP.SB</a>,免费接口一般会有请求速率限制。')
		);
		$form->addInput($element);
		
		$element = new Typecho_Widget_Helper_Form_Element_Checkbox('check_win11',
			array(
				'add_header' => _t('添加 Header'),
				'checked' => _t('启用 Windows 11 检测')
			), 
			array(),
			_t('请选择 Windows 11 优化项 [可选]'), 
			_t('<b>添加 Header：</b>默认不勾选,勾选后将添加:</br><code style="padding: 2px 4px; font-size: 90%; color: #c7254e; background-color: #f9f2f4; border-radius: 4px;">header("Accept-CH: Sec-CH-UA-Full-Version,Sec-CH-UA-Platform-Version");</code></br>建议在Nginx或者Apache等配置中添加Header,而非在此启用！！！</br><b>启用 Windows 11 检测：</b>默认不勾选,勾选后将会重写访问者 UserAgent 信息，此项仅在支持 HTTPS 且正确添加 Header 后的站点下有效，无法检测已有评论！！！'));
		$form->addInput($element);

		$element = new Typecho_Widget_Helper_Form_Element_Select('instant_page',
			array(
				'off'=>_t('禁用此功能'),
				'local'=>_t('本地加载源'),
				'official'=>_t('官方加载源'),
				'baomitu'=>_t('75CDN')
			),
			'off',
			_t('Instant.page（提高网站页面加载速度）[可选]'),
			_t('由于官方加载源是存储在国外,所以建议各位合理选择加载源,以缩短脚本载入的时间</br><a href="https://instant.page/" target="_blank">Instant.page官网</a> | <a href="https://www.usebsd.com/633.html" target="_blank">了解Instant.page</a></br></br>请在需要显示评论信息的位置插入下方嵌入点代码:</br><code style="padding: 2px 4px; font-size: 90%; color: #c7254e; background-color: #f9f2f4; border-radius: 4px;">&lt;?php UserAgent_Plugin::get_useragent($comments->agent,$comments->ip); ?&gt;</code>')
		);
		$form->addInput($element);

	}

	/**
	 * 个人用户的配置面板
	 *
	 * @access public
	 * @param Typecho_Widget_Helper_Form $form
	 * @return void
	 */
	public static function personalConfig(Typecho_Widget_Helper_Form $form)
	{
	}
	
	 /**
	 *为header添加css文件
	 *@return void
	 */
	public static function header()
	{
		$cssUrl = Helper::options()->pluginUrl . '/UserAgent/css/useragent.css';
		echo '<link rel="stylesheet" type="text/css" href="//at.alicdn.com/t/c/font_1166601_skstskq3igi.css">' . PHP_EOL . '<link rel="stylesheet" type="text/css" href="' . $cssUrl . '" />';
	}

	/**
	 *为footer添加js文件
	 *@return void
	 */
	public static function footer() {
		$type = Helper::options()->plugin('UserAgent')->instant_page;
		switch ($type) {
			case 'official':
				echo '<script src="//instant.page/5.2.0" type="module" defer integrity="sha384-jnZyxPjiipYXnSU0ygqeac2q7CVYMbh84q0uHVRRxEtvFPiQYbXWUorga2aqZJ0z"></script>';
				break;
	
			case 'local':
				$jsUrl = helper::options()->pluginUrl . '/UserAgent/js/instant.page-5.2.0.js';
				echo '<script src="' . $jsUrl . '" type="module" integrity="sha384-jnZyxPjiipYXnSU0ygqeac2q7CVYMbh84q0uHVRRxEtvFPiQYbXWUorga2aqZJ0z"></script>';
					break;	
	
			case 'baomitu':
				echo '<script crossorigin="anonymous" integrity="sha512-7Thaz9BNaNnxeS2p1MKreIVdJxZ0HS189YnwMTu4BZHjT1SSMJzh0IKtcWqZJ2y8Zt74gClrUGNM6Lv+t3ziGw==" src="https://lib.baomitu.com/instant.page/5.1.1/instantpage.js"></script>';
				break;
	
			default:
				//none
				break;	
		}
		
	}

	 /**
	 *在 handleInit 处添加 Header 和重写 $_SERVER['HTTP_USER_AGENT'] 信息
	 *@return void
	 */
	public static function handleInit()
	{
		if (self::exist_value('add_header', Helper::options()->plugin('UserAgent')->check_win11)) {
			header("Accept-CH: Sec-CH-UA-Full-Version,Sec-CH-UA-Platform-Version");
		}
		
		if (self::exist_value('checked', Helper::options()->plugin('UserAgent')->check_win11)) {
			$HTTP_SEC_CH_UA_PLATFORM = isset($_SERVER['HTTP_SEC_CH_UA_PLATFORM']) ? str_replace('"','',$_SERVER['HTTP_SEC_CH_UA_PLATFORM']) : '0.0.0';
			$HTTP_SEC_CH_UA_PLATFORM_VERSION = isset($_SERVER['HTTP_SEC_CH_UA_PLATFORM_VERSION']) ? str_replace('"','',$_SERVER['HTTP_SEC_CH_UA_PLATFORM_VERSION']) : '0.0.0';
			if($HTTP_SEC_CH_UA_PLATFORM === 'Windows' && version_compare($HTTP_SEC_CH_UA_PLATFORM_VERSION, '13.0.0', '>=')){
				$_SERVER['HTTP_USER_AGENT'] = str_replace("Windows NT 10.0", "Windows NT 11.0", $_SERVER['HTTP_USER_AGENT']);
			}
		}
	}	

	/**
	 * 获取浏览器型号
	 * @access public
	 * @param $ua => $comments->agent
	 * @return $array['title'] => 返回浏览器型号, $array['icon'] => 返回浏览器对应图标
	 */	
	public static function get_browsers($ua){
		$title = '非主流浏览器';
		$icon = 'iconfontua icon-browser';
		if(preg_match('/rv:(11.0)/i', $ua, $matches)){
			$title = 'Internet Explorer '. $matches[1];
			$icon = 'iconfontua icon-internet-explorer';//ie11
		}elseif (preg_match('#MSIE ([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Internet Explorer '. $matches[1];
			
			if ( strpos($matches[1], '7') !== false || strpos($matches[1], '8') !== false)
				$icon = 'iconfontua icon-internet-explorer';//ie8
			elseif ( strpos($matches[1], '9') !== false)
				$icon = 'iconfontua icon-internet-explorer';//ie9
			elseif ( strpos($matches[1], '10') !== false)
				$icon = 'iconfontua icon-internet-explorer';//ie10
		}elseif (preg_match('#Edg[A-Za-z]*/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Microsoft Edge '. $matches[1];
			$icon = 'iconfontua icon-edge';	
		}elseif (preg_match('#TheWorld ([a-zA-Z0-9.]+)#i', $ua, $matches)){
			$title = 'TheWorld(世界之窗) '. $matches[1];
			$icon = 'iconfontua icon-theworld';
		}elseif (preg_match('#JuziBrowser#i', $ua, $matches)){
			$title = 'Juzi(桔子) ';//.$matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('#KBrowser#i', $ua, $matches)){
			$title = 'KBrowser(超快) ';//.$matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('#MyIE#i', $ua, $matches)){
			$title = 'MyIE(蚂蚁) ';//.$matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('#(?:Firefox|Phoenix|Firebird|BonEcho|GranParadiso|Minefield|Iceweasel)/([a-zA-Z0-9.]+)#i', $ua, $matches)){
			$title = 'Firefox '. $matches[1];
			$icon = 'iconfontua icon-firefox';
		}elseif (preg_match('#CriOS/([a-zA-Z0-9.]+)#i', $ua, $matches)){
			$title = 'Chrome for iOS '. $matches[1];
			$icon = 'iconfontua icon-chrome';
		} elseif (preg_match('#(?:LieBaoFast|LBBROWSER)/?([a-zA-Z0-9.]+)#i', $ua, $matches)) {
            $title = '猎豹 '. $matches[1];
			$icon = 'iconfontua icon-liebaoliulanqi';
		}elseif (preg_match('#Opera.(.*)Version[ /]([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Opera '. $matches[2];
			$icon = 'iconfontua icon-opera';
			if (preg_match('#opera mini#i', $ua)) 
				$title = 'Opera Mini '. $matches[2];
		}elseif (preg_match('#(?:OPR|OPT)/?([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Opera '. $matches[1];
			$icon = 'iconfontua icon-opera';
		}elseif (preg_match('#Maxthon( |\/)([a-zA-Z0-9.]+)#i', $ua,$matches)) {
			$title = 'Maxthon(遨游) '. $matches[2];
			$icon = 'iconfontua icon-liulanqi-aoyou';
		}elseif (preg_match('/360/i', $ua, $matches)) {
			$title = '360浏览器';//放弃360怪异UA
			$icon = 'iconfontua icon-browser-360';
			if (preg_match('/Alitephone Browser/i', $ua)) {
				$title = '360极速浏览器';
				$icon = 'iconfontua icon-liulanqi-jisu';
			}
		}elseif (preg_match('#(?:SE |SogouMobileBrowser/)([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '搜狗浏览器 '.$matches[1];
			$icon = 'iconfontua icon-liulanqi-sougou';
		}elseif (preg_match('#QQ/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'QQ '.$matches[1];
			$icon = 'iconfontua icon-qq';
		}elseif (preg_match('#MicroMessenger/([a-zA-Z0-9.]+)#i', $ua,$matches)) {
			$title = '微信 '. $matches[1];
			$icon = 'iconfontua icon-wechat';
		}elseif (preg_match('#QQBrowser/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'QQ浏览器 '.$matches[1];
			$icon = 'iconfontua icon-QQliulanqi';
		}elseif (preg_match('#YYE/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'YY浏览器 '.$matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('#115Browser/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '115 '.$matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('#37abc/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '37abc '.$matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('#UCWEB([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'UC '. $matches[1];
			$icon = 'iconfontua icon-ucliulanqi';
		}elseif (preg_match('#UC?Browser/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'UC '. $matches[1];
			$icon = 'iconfontua icon-ucliulanqi';
		}elseif (preg_match('#Quark/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '夸克 '. $matches[1];
			$icon = 'iconfontua icon-kuakeliulanqi';
		}elseif (preg_match('#2345(?:Explorer|Browser)/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '2345浏览器 '. $matches[1];
			$icon = 'iconfontua icon-browser';	
		}elseif (preg_match('#XiaoMi/MiuiBrowser/([0-9.]+)#i', $ua, $matches)) {
			$title = '小米 '. $matches[1];
			$icon = 'iconfontua icon-xiaomi';	
		}elseif (preg_match('#SamsungBrowser/([0-9.]+)#i', $ua, $matches)) {
			$title = '三星 '. $matches[1];
			$icon = 'iconfontua icon-sanxing1';
		}elseif (preg_match('/WeiBo/i', $ua, $matches)) {
			$title = '微博 ';//. $matches[1];
			$icon = 'iconfontua icon-weibo';
		}elseif (preg_match('/BIDU/i', $ua, $matches)) {
			$title = '百度 ';//. $matches[1];
			$icon = 'iconfontua icon-browser-baidu';
		}elseif (preg_match('#baiduboxapp/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '百度 '. $matches[1];
			$icon = 'iconfontua icon-browser-baidu';	
		}elseif (preg_match('#SearchCraft/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '简单搜索 '. $matches[1];
			$icon = 'iconfontua icon-browser-baidu';
		}elseif (preg_match('#Qiyu/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '旗鱼浏览器 '. $matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('#mailapp/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '邮箱客户端 '. $matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('/Sleipnir/i', $ua, $matches)) {
			$title = '神马 ';//. $matches[1];
			$icon = 'iconfontua icon-browser-shenma';
		}elseif (preg_match('/MZBrowser/i', $ua, $matches)) {
			$title = '魅族 ';//. $matches[1];
			$icon = 'iconfontua icon-meizu';
		}elseif (preg_match('/VivoBrowser/i', $ua, $matches)) {
			$title = 'vivo ';//. $matches[1];
			$icon = 'iconfontua icon-ua-vivo';
		}elseif (preg_match('/mixia/i', $ua, $matches)) {
			$title = '米侠 ';//. $matches[1];
			$icon = 'iconfontua icon-browser';
		}elseif (preg_match('#CoolMarket/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '酷安 '. $matches[1];//typecho ua获取不完整
			$icon = 'iconfontua icon-coolapk';	
		}elseif (preg_match('#YaBrowser/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Yandex '. $matches[1];
			$icon = 'iconfontua icon-yandex';
		//2023-02-25更新
		}elseif (preg_match('#Focus/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Firefox Focus '. $matches[1];
			$icon = 'iconfontua icon-firefox';//暂未更新
		}elseif (preg_match('#Vivaldi/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Vivaldi '. $matches[1];
			$icon = 'iconfontua icon-vivaldi-splash';
		}elseif (preg_match('#Arora/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Arora '. $matches[1];
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#HeyTapBrowser/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'OPPO '. $matches[1];
			$icon = 'iconfontua icon-oppo';
		}elseif (preg_match('#wxwork/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '企业微信 '. $matches[1];
			$icon = 'iconfontua icon-qiyeweixin';
		}elseif (preg_match('#AliApp\(TB/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '淘宝 '. $matches[1];
			$icon = 'iconfontua icon-taobao';
		}elseif (preg_match('#AliApp\(AP/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '支付宝 '. $matches[1];
			$icon = 'iconfontua icon-alipay';
		}elseif (preg_match('#com.douban.frodo/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '豆瓣 '. $matches[1];
			$icon = 'iconfontua icon-douban';
		}elseif (preg_match('#SNEBUY-APP/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '苏宁易购 '. $matches[1];
			$icon = 'iconfontua icon-suningyigou';
		}elseif (preg_match('#IqiyiVersion/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '爱奇艺 '. $matches[1];
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#DingTalk/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '钉钉 '. $matches[1];
			$icon = 'iconfontua icon-dingding';
		}elseif (preg_match('#app_version/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '抖音 '. $matches[1];
			$icon = 'iconfontua icon-douyin';
		}elseif (preg_match('#(?:HuaweiBrowser|HUAWEI/|HONOR|HBPC/)/?([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '华为 '. $matches[1];
			$icon = 'iconfontua icon-huawei';
		}elseif (preg_match('#Puffin/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Puffin '. $matches[1];
			$icon = 'iconfontua icon-puffin';
		}elseif (preg_match('#Kindle/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Kindle '. $matches[1];
			$icon = 'iconfontua icon-kindle';
		}elseif (preg_match('/Links/i', $ua)) {
			$title = 'Links ';
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#Netscape/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = '网景 '. $matches[1];
			$icon = 'iconfontua icon-netscape';
		}elseif (preg_match('#Flock/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Flock '. $matches[1];
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#iCab/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'iCab '. $matches[1];
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#Iceape/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Iceape '. $matches[1];
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#icecat/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'icecat '. $matches[1];
			$icon = 'iconfontua icon-gnuicecat';
		}elseif (preg_match('#Iron/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Iron '. $matches[1];
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#K-Meleon/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'K-Meleon '. $matches[1];
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#TizenBrowser/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Tizen '. $matches[1];
			$icon = 'iconfontua icon-browser';//暂未更新
		}elseif (preg_match('#Tesla/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Tesla '. $matches[1];
			$icon = 'iconfontua icon-tesla';
		}elseif (preg_match('#Brave/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Brave '. $matches[1];
			$icon = 'iconfontua icon-brave';
		}elseif (preg_match('#Instagram( |\/)([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Instagram '. $matches[2];
			$icon = 'iconfontua icon-instagram';
		}elseif (preg_match('#FBAV/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Facebook '. $matches[1];
			$icon = 'iconfontua icon-facebook1';
		}elseif (preg_match('#Chromium/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Chromium '. $matches[1];
			$icon = 'iconfontua icon-chromium';//※必须放在末尾
		}elseif (preg_match('#Chrome/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Google Chrome '. $matches[1];
			$icon = 'iconfontua icon-chrome';//※必须放在末尾
		}elseif (preg_match('#Safari/([a-zA-Z0-9.]+)#i', $ua, $matches)) {
			$title = 'Safari '. $matches[1];
			$icon = 'iconfontua icon-safari';//※必须放在末尾
		}
		return array('title' => $title, 'icon' => $icon);
	}

	/**
	 * 获取操作系统类型
	 * @access public
	 * @param $ua => $comments->agent
	 * @return $array['title'] => 返回操作系统类型, $array['icon'] => 返回操作系统对应图标 
	 */
	public static function get_os($ua){
		$title = '非主流操作系统';
		$icon = 'iconfontua icon-ua-search';
		if (preg_match('/win/i', $ua)) {
			if (preg_match('/Windows NT 6.1/i', $ua)) {
				$title = "Windows 7";
				$icon = "iconfontua icon-win";
			}elseif (preg_match('/Windows 95/i', $ua)) {
				$title = "Windows 95";
				$icon = "iconfontua icon-win2";	
			}elseif (preg_match('/Windows 98/i', $ua)) {
				$title = "Windows 98";
				$icon = "iconfontua icon-win2";
			}elseif (preg_match('/Windows NT 5.0/i', $ua)) {
				$title = "Windows 2000";
				$icon = "iconfontua icon-win2";	
			}elseif (preg_match('/Windows NT 5.1/i', $ua)) {
				$title = "Windows XP";
				$icon = "iconfontua icon-win";
			}elseif (preg_match('/Windows NT 5.2/i', $ua)) {
				if (preg_match('/Win64/i', $ua)) {
					$title = "Windows XP 64 bit";
				} else {
					$title = "Windows Server 2003";
				}
				$icon = 'iconfontua icon-win';
			}elseif (preg_match('/Windows NT 6.0/i', $ua)) {
				$title = "Windows Vista";
				$icon = "iconfontua icon-windows";
			}elseif (preg_match('/Windows NT 6.2/i', $ua)) {
				$title = "Windows 8";
				$icon = "iconfontua icon-win8";
			}elseif (preg_match('/Windows NT 6.3/i', $ua)) {
				$title = "Windows 8.1";
				$icon = "iconfontua icon-win8";
			}elseif (preg_match('/Windows NT 10.0/i', $ua)) {
				$title = "Windows 10";
				$icon = "iconfontua icon-win3";
			}elseif (preg_match('/Windows NT 11.0/i', $ua)) {//检测重写后的UA
				$title = "Windows 11";
				$icon = "iconfontua icon-win3";
			}elseif (preg_match('/Windows Phone/i', $ua)) {
				$matches = explode(';',$ua);
				$title = $matches[2];
				$icon = "iconfontua icon-winphone";
			}
		} elseif (preg_match('#iPod.*.CPU.([a-zA-Z0-9.( _)]+)#i', $ua, $matches)) {
			$title = "iPod ".str_replace('_', '.', $matches[2]);
			$icon = "iconfontua icon-ipod";
		} elseif (preg_match('/iPhone OS ([_0-9]+)/i', $ua, $matches)) {
			$title = "iPhone ".str_replace('_', '.', $matches[1]);
			$icon = "iconfontua icon-iphone1";
		} elseif (preg_match('/iPad; CPU OS ([_0-9]+)/i', $ua, $matches)) {
			$title = "iPad ".str_replace('_', '.', $matches[1]);
			$icon = "iconfontua icon-ipad";
		} elseif (preg_match('/(mac os x) ?([\w\. ]*)/i', $ua, $matches)) {// /(mac os x) ?([\w\. ]*)/i    /Mac OS X ([0-9_]+)/i
			$title = "Mac OS X ".str_replace('_', '.', $matches[2]);
			$icon = "iconfontua icon-mac-os";
		} elseif (preg_match('/Macintosh/i', $ua)) {
			$title = "Mac OS";
			$icon = "iconfontua icon-mac-os";
		} elseif (preg_match('/CrOS/i', $ua)){
			$title = "Google Chrome OS";
			$icon = "iconfontua icon-iconchromeos";
		} elseif (preg_match('/Android.([0-9. _]+)/i',$ua, $matches)) {
				$title= "Android " . $matches[1];
				$icon = "iconfontua icon-android";	
		} elseif (preg_match('/OpenBSD/i', $ua)){
			$title = "OpenBSD";
			$icon = "iconfontua icon-openbsd";//暂未更新
		} elseif (preg_match('/Linux/i', $ua)) {
			$title = 'Linux';
			$icon = 'iconfontua icon-linux';
			if (preg_match('/Ubuntu/i', $ua)) {
				$title = "Ubuntu Linux";
				$icon = "iconfontua icon-ubuntu";
			} elseif (preg_match('#Debian#i', $ua)) {
				$title = "Debian GNU/Linux";
				$icon = "iconfontua icon-debian";
			} elseif (preg_match('#Fedora#i', $ua)) {
				$title = "Fedora Linux";
				$icon = "iconfontua icon-fedora";
			}
		}	
		return array('title' => $title, 'icon' => $icon);
	}

	/**
	 * 嵌入点,输出信息
	 * @access public
	 * @param $ua => $comments->agent, $ip => $comments->ip
	 * @return void
	 */	
	public static function get_useragent($ua, $ip=null)
	{
		$options = Typecho_Widget::widget('Widget_Options');
		$plugin_opt = $options->plugin('UserAgent');
		if (!isset($options->plugins['activated']['UserAgent'])) {
			return _t('UserAgent插件未激活');
		}

		//UA仅博主可见
		Typecho_Widget::widget('Widget_User')->to($user);
		if ($user->group !== 'administrator' && self::exist_value('visible', $plugin_opt->effect)) {
			return;
		}  

		$color_info = self::get_color($ua . 'songshu');
		$os_info = self::get_os($ua);
		$br_info = self::get_browsers($ua);

		//显示IP位置信息
		if (self::exist_value('loc', $plugin_opt->ip) && (!self::exist_value('visible', $plugin_opt->ip) || $user->group === 'administrator')) {
			$ip_info = self::get_loc($ip);
			if ($plugin_opt->info) {
				$code_ip = self::get_format($color_info, $ip_info, '', $ip_info);
			} else {
				$code_ip = self::get_format($color_info, $ip_info);	
			}
		}
		
		//显示UA详细信息
		$plugin_opt->info ? $br_info_title=$br_info['title'] : $br_info_title='';
		$plugin_opt->info ? $os_info_title=$os_info['title'] : $os_info_title='';
		$code_br = self::get_format($color_info, $br_info['title'], $br_info['icon'], $br_info_title);
		$code_os = self::get_format($color_info, $os_info['title'], $os_info['icon'], $os_info_title);

		//显示悬停效果
		$ua_class = self::exist_value('color', $plugin_opt->effect) ? 'class="ua-hover"' : '' ;

		//输出前检查变量是否存在
		//首行 - error_reporting(0);
		//php.ini - error_reporting = E_ALL & ~E_NOTICE
		$code_ip = isset($code_ip) ? $code_ip : '' ;

		//输出信息 - '@' 掩耳盗铃之术
		echo "<span {$ua_class}>" . @$code_br . @$code_os . @$code_ip . '</span>';
	}

	/**
	 * 控制输出格式
	 */	
	public static function get_format($color, $title, $icon=null, $text=null) 
	{
		empty($icon) ? $icon_code='iconfontua icon-location-arrow' : $icon_code=$icon ;
		$code = '<span class="ua-icon"' . $color . ' data-toggle="tooltip" data-original-title="'. $title .'"><i class="' . $icon_code . ' " aria-hidden="true"></i> ' . $text . '</span>';
		return $code;
	}
	
	/**
	 * 获取颜色
	 * @access public
	 * @param $text => $comments->agent
	 * @return $code => 返回style代码
	 *
	 * 灵感来源: https://black1ce.com/website/typecho-ua.html
	 */	
	public static function get_color($text)
	{
		if (Helper::options()->plugin('UserAgent')->color) {//随机颜色
			$hash = md5(strtolower($text));
			$color = '#' . substr($hash,9,6);
			$code = 'style="background:' . $color . '"';
		} elseif (Helper::options()->plugin('UserAgent')->color_value == '') {//默认颜色
			$code = 'style="background:#924cda"';
		} else {//自定义颜色
			$code = 'style="background:' . htmlspecialchars(Helper::options()->plugin('UserAgent')->color_value) . '"';
		}
		return $code;
	}

	/**
	 * 获取位置信息
	 * @access public
	 * @param $ip => $comments->ip
	 * @return 返回对应IP的位置信息
	 */		
	public static function get_loc($ip)
	{
		if (file_exists(__DIR__ . '/vendor/autoload.php') && file_exists(__DIR__ . '/lib/ipdbv6.func.php')) {
				@include_once __DIR__ . '/vendor/autoload.php';
				@include_once __DIR__ . '/lib/ipdbv6.func.php';
			} else {
				print('Missing Autoload File');
		}

		$options = Typecho_Widget::widget('Widget_Options');
		$plugin_opt = $options->plugin('UserAgent');
		$opt_api = $plugin_opt->api;
		
		try {
			if (self::is_ipv4($ip)) {
				switch ($plugin_opt->ipv4_source) {
					case 'IPIP'://IPIP.NET数据库
						$ipdb_file = __DIR__ . '/lib/ipipfree.ipdb';
						break;
					
					case 'qqwry'://纯真IP数据库
					default:
						$ipdb_file = __DIR__ . '/lib/qqwry.ipdb';
						break;
				}
				$ipipdb = new ipip\db\City($ipdb_file);
				$response = $ipipdb->findMap($ip, 'CN');
				if (is_array($response)) {
					$response = array_filter(array_unique($response));
					$response = array(
						'code' => 0,
						'data' => implode(' ', $response),
					);
					return $response['data'];
				} else {
					throw new Exception('解析IP失败');
				}
			} elseif (self::is_ipv6($ip)) {
				switch ($plugin_opt->ipv6_source) {
					case 'ipv6wry'://ipv6wry.db数据库
					default:
						$ipdb_file = __DIR__ . '/lib/ipv6wry.db';
						break;
				}
				$ipdbv6 = new ipdbv6($ipdb_file);
				$response = $ipdbv6->query($ip);
				if (is_array($response)) {
					$response = array_filter(array_unique($response));
					return $response['disp'];
				} else {
					throw new Exception('解析IP失败');
				} 
				
			} else {
				throw new Exception('非法IP！');
			}			
			
		} catch (Exception $e) {
			if ($opt_api === 'None') {
				return _t('暂无此IP信息!');
			}
			$http = Typecho_Http_Client::get();
			$http->setHeader('user-agent','Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36 Edg/138.0.0.0');
			$http->setTimeout(3);
			switch ($opt_api) {		
				case 'IP-API':
					$url = 'http://ip-api.com/json/' . $ip . '?lang=zh-CN';
					$http->setHeader('referer','http://ip-api.com');
					$http->setHeader('Accept-Language','zh-CN,zh;q=0.9');
					break;
					
				case 'IPinfo':
					$url = 'https://ipinfo.io/' . $ip . '/json';
					$http->setHeader('referer','https://ipinfo.io/');
					break;
					
				case 'VORE-API':
					$url = 'https://api.vore.top/api/IPdata?ip=' . $ip;
					$http->setHeader('referer','api.vore.top');
					break;
				
				case 'Mir6':
					$url = 'https://api.mir6.com/api/ip_json?ip=' . $ip;
					$http->setHeader('referer','api.mir6.com');
					break;
					
				case 'SB':
				default:
					$url = 'https://api.ip.sb/geoip/' . $ip;
					$http->setHeader('referer','https://ip.sb/api/');
					break;
			}

			try {
				$http->send($url);
				if (429== $http->getResponseStatus()) {
					return _t('速率限制!');
				}
				$response = $http->getResponseBody();
				$result = json_decode($response);
				if (empty($result)) {
					return _t('无法获取IP信息!');
				}
				
				switch ($opt_api) {		
					case 'IP-API':
						if ($result->status !== 'success' || ($result->city == null && $result->country == null)) {
							return _t('暂无此IP信息!');
						}
						return $result->country . ', ' . $result->city . '; ' . $result->isp;
						break;
						
					case 'IPinfo':
						if ($result->city == null && $result->country == null) {
							return _t('暂无此IP信息!');
						}
						return $result->city . ', ' . $result->country . '; ' . $result->org;
						break;
						
					case 'VORE-API':
						if ($result->code !== 200 || empty($result->adcode->o)) {
							return _t('暂无此IP信息!');
						}
						return $result->adcode->o;
						break;
					
					case 'Mir6':
						if ($result->code !== 200 || ($result->data->city == null && $result->data->country == null)) {
							return _t('暂无此IP信息!');
						}
						return $result->data->location . '; ' . $result->data->isp;
						break;	
						
					case 'SB':
						if ($result->city == null && $result->country == null) {
							return _t('暂无此IP信息!');
						} elseif ($result->city == null) {
							return $result->country . '; ' . $result->isp;
						}
						return $result->city . ', ' . $result->country . '; ' . $result->isp;
						break;
						
					default:
						return _t('无法获取IP信息!');
				}
				return _t('无法获取IP信息!');
			} catch (Exception $e) {
				return _t('无法获取IP信息!');
			}
		}
	}

	/**
	* 判断值是否有效存在
	* @access public
	* @param $value
	* @return 返回bool类型
	*/		
	public static function exist_value($value, $array, $strict = false)
	{
		if (isset($array)) {
			return in_array($value, $array, $strict);
		}
		return false;
	}

	/**
	* 判断合法的IPV4
	* @access public
	* @param $ip
	* @return 返回bool类型
	*/		
	public static function is_ipv4($ip)
	{
		if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4)) {
			return true;
		}
		return false;
	}
	
	/**
	* 判断合法的IPV6
	* @access public
	* @param $ip
	* @return 返回bool类型
	*/		
	public static function is_ipv6($ip)
	{
		if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV6)) {
			return true;
		}
		return false;
	}	
}
